PROGRAM TcpServer
VAR_EXTERNAL

END_VAR

VAR_GLOBAL

END_VAR

VAR

lanInit:bool:=false;

inst0_LAN_INIT:LAN_INIT;

mConfirm:bool;
mError:usint;
mErrorinfo:usint;

mIP:udint;
mNetMask:udint;
mGateWay:udint;

mSocket:INT;
inst4_LAN_TCP_SERVER_CREATE:LAN_TCP_SERVER_CREATE;

mTcpCreateOK:bool:=false;

mClientSocket:INT;
mPeer:udint;
mPeerPort:uint;

inst5_LAN_GET_TCPCONNECT_SOCKET:LAN_GET_TCPCONNECT_SOCKET;
inst6_LAN_TCP_RECV_BIN:LAN_TCP_RECV_BIN;
inst7_LAN_TCP_SEND_BIN:LAN_TCP_SEND_BIN;
mRxLen:int;

abDataBuffer : ARRAY[0..1500] OF BYTE;
pDataObject : POINTER;

i :int;
tmplen:int;
END_VAR

if lanInit=false then

mIP := LAN_ASCII_TO_INET('192.168.1.33');
mNetMask := LAN_ASCII_TO_INET('255.255.255.0');
mGateWay := LAN_ASCII_TO_INET('192.168.1.1');			
	inst0_LAN_INIT(ENABLE :=true , 
			HOSTNAME := 'PLCCore', 
			IP := mIP, 
			NETMASK :=mNetMask, 
			GATEWAY :=mGateWay ,
			NETNUMBER:=1
			|  mConfirm:= CONFIRM, 
			 mError:= ERROR, 
			 mErrorinfo:= ERRORINFO);
	        lanInit:=true;
else

	if mTcpCreateOK=false then
		inst4_LAN_TCP_SERVER_CREATE(PORT :=8089 ,
		 ENABLE := true, 
		 NETNUMBER := 1 
		 |  
		 mSocket:= SOCKET_ID,  
		 mConfirm:= CONFIRM,  
		 mError:= ERROR,  
		 mErrorinfo:= ERRORINFO);
		 
		 if mSocket>=0 then 
		 mTcpCreateOK:=true;
         end_if;
		 
	end_if;

end_if;

pDataObject:=&abDataBuffer;

if mTcpCreateOK=true then

	

	inst5_LAN_GET_TCPCONNECT_SOCKET(SOCKET_ID := mSocket, NETNUMBER := 1 |  mClientSocket:= CLIENT_SOCKET_ID,  mPeer:= PEER_ADDR,  mPeerPort:= PEER_PORT,  mError:= ERROR);

	if mClientSocket>=0 then
	
		inst6_LAN_TCP_RECV_BIN(CLIENT_SOCKET_ID :=mClientSocket , 
			PTR_RXDATA :=pDataObject , 
			MAXLENGTH := 1500, 
			ENABLE :=1 , 
			NETNUMBER := 1 |  mRxLen:= RXLENGTH,  mConfirm:= CONFIRM,  mError:= ERROR,  mErrorinfo:= ERRORINFO);

		if mRxLen>0 then
			tmplen:=mRxLen;
			inst7_LAN_TCP_SEND_BIN(CLIENT_SOCKET_ID :=mClientSocket , 
				PTR_TXDATA :=pDataObject , 
				TXLENGTH := mRxLen, 
				ENABLE :=1 , 
				NETNUMBER :=1  |  mConfirm:= CONFIRM, mError := ERROR,  mErrorinfo:= ERRORINFO);
			
		end_if;
	end_if;
end_if;



END_PROGRAM